/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp;

import com.google.common.annotations.VisibleForTesting;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.util.RepeatingList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SupplyJoiner {
    private static final Logger log = LoggerFactory.getLogger(SupplyJoiner.class);

    @VisibleForTesting
    protected static List<Double> getConsolidatedQties(double totalQty, double minBatch, double maxBatch, double batchStep) {
        return SupplyJoiner.getConsolidatedQties(totalQty, minBatch, maxBatch, batchStep, null);
    }

    public static List<Double> getConsolidatedQties(double totalQty, double minBatch, double maxBatch, double batchStep, Material mat) {
        double minRem;
        if (maxBatch < 0.0 || totalQty < maxBatch) {
            return Collections.singletonList(totalQty);
        }
        double maxRem = maxBatch % batchStep;
        if (!(maxRem < 1.0E-7) && !(maxRem > batchStep - 1.0E-7)) {
            if (mat != null) {
                log.warn("maxBatch is not divisible by batchStep for {}", (Object)mat.getName());
            } else {
                log.warn("maxBatch is not divisible by batchStep");
            }
        }
        if (!((minRem = minBatch % batchStep) < 1.0E-7) && !(minRem > batchStep - 1.0E-7)) {
            if (mat != null) {
                log.warn("minBatch is not divisible by batchStep for {}", (Object)mat.getName());
            } else {
                log.warn("minBatch is not divisible by batchStep");
            }
        }
        if (minBatch > maxBatch) {
            if (mat != null) {
                log.error("minBatch greater than maxBatch for {}. Setting minBatch = 0.", (Object)mat.getName());
            } else {
                log.error("minBatch greater than maxBatch. Setting minBatch = 0.");
            }
            minBatch = 0.0;
        }
        RepeatingList<Double> qties = RepeatingList.create();
        int maxBatchSteps = (int)(totalQty / maxBatch);
        double remainingQty = totalQty - (double)maxBatchSteps * maxBatch;
        if (remainingQty < 1.0E-7) {
            qties.addNTimes(maxBatchSteps, maxBatch);
            return qties;
        }
        if (remainingQty > minBatch) {
            double remRem = remainingQty % batchStep;
            if (remRem < 1.0E-7 || remRem > batchStep - 1.0E-7) {
                qties.addNTimes(maxBatchSteps, maxBatch);
                qties.add(remainingQty);
            } else {
                double batchFitDiff = remainingQty - Math.floor(remainingQty / batchStep) * batchStep;
                double lastMaxBatch = maxBatch - (batchStep - batchFitDiff);
                double finalRemains = Math.ceil(remainingQty / batchStep) * batchStep;
                if (lastMaxBatch < minBatch || finalRemains > maxBatch) {
                    qties.addNTimes(maxBatchSteps, maxBatch);
                    qties.add(remainingQty);
                } else {
                    qties.addNTimes(maxBatchSteps - 1, maxBatch);
                    qties.add(lastMaxBatch);
                    qties.add(finalRemains);
                }
            }
        } else {
            double neededQty = minBatch - remainingQty;
            double minMaxDiff = maxBatch - minBatch;
            int maxBatchesToReduceToMin = (int)Math.floor(neededQty / minMaxDiff);
            double rest = neededQty - (double)maxBatchesToReduceToMin * minMaxDiff;
            if (rest < 1.0E-7) {
                int maxBatchesToAdd = maxBatchSteps - maxBatchesToReduceToMin;
                if (maxBatchesToAdd >= 0) {
                    qties.addNTimes(maxBatchesToAdd, maxBatch);
                    qties.addNTimes(maxBatchesToReduceToMin, minBatch);
                    qties.add(minBatch);
                } else {
                    qties.addNTimes(maxBatchSteps, maxBatch);
                    qties.add(remainingQty);
                }
            } else {
                int maxBatchesToAdd = maxBatchSteps - maxBatchesToReduceToMin - 1;
                if (maxBatchesToAdd >= 0) {
                    qties.addNTimes(maxBatchesToAdd, maxBatch);
                    qties.addNTimes(maxBatchesToReduceToMin + 1, minBatch);
                    qties.add(maxBatch - rest);
                } else {
                    qties.addNTimes(maxBatchSteps, maxBatch);
                    qties.add(remainingQty);
                }
            }
        }
        return qties;
    }
}

